<?php
require_once '../config/config.php';
require_once '../includes/auth_check.php';

if (!isset($_POST['customer_id'])) {
    die('Customer ID is required');
}

$customer_id = (int)$_POST['customer_id'];

// Get customer details
$stmt = $pdo->prepare("SELECT name, phone FROM customers WHERE id = ?");
$stmt->execute([$customer_id]);
$customer = $stmt->fetch();

if (!$customer) {
    die('Customer not found');
}

// Get customer's purchase history
$stmt = $pdo->prepare("
    SELECT 
        s.id,
        s.sale_date,
        s.total_amount,
        FLOOR(s.total_amount / 100) as points_earned
    FROM sales s
    WHERE s.customer_id = ?
    ORDER BY s.sale_date DESC
");
$stmt->execute([$customer_id]);
$purchases = $stmt->fetchAll();

// Calculate total points
$total_points = 0;
foreach ($purchases as $purchase) {
    $total_points += $purchase['points_earned'];
}
?>

<div class="customer-info mb-4">
    <h4><?php echo htmlspecialchars($customer['name']); ?></h4>
    <p>Phone: <?php echo htmlspecialchars($customer['phone']); ?></p>
    <p>Total Points: <strong><?php echo $total_points; ?></strong></p>
</div>

<table class="table table-bordered">
    <thead>
        <tr>
            <th>Date</th>
            <th>Amount (Ksh)</th>
            <th>Points Earned</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($purchases as $purchase): ?>
        <tr>
            <td><?php echo date('Y-m-d H:i', strtotime($purchase['sale_date'])); ?></td>
            <td><?php echo number_format($purchase['total_amount'], 2); ?></td>
            <td><?php echo $purchase['points_earned']; ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table> 